<?php // -*-mode: PHP; coding:utf-8;-*-
declare(strict_types=1);
namespace MRBS;

use IntlDateFormatter;

require_once 'lib/autoload.inc';

/**************************************************************************
 *   MRBS Configuration File
 *   Configure this file for your site.
 *   You shouldn't have to modify anything outside this file.
 *
 *   This file has already been populated with the minimum set of configuration
 *   variables that you will need to change to get your system up and running.
 *   If you want to change any of the other settings in systemdefaults.inc.php
 *   or areadefaults.inc.php, then copy the relevant lines into this file
 *   and edit them here.   This file will override the default settings and
 *   when you upgrade to a new version of MRBS the config file is preserved.
 *
 *   NOTE: if you include or require other files from this file, for example
 *   to store your database details in a separate location, then you should
 *   use an absolute and not a relative pathname.
 **************************************************************************/

/**********
 * Timezone
 **********/

// The timezone your meeting rooms run in. It is especially important
// to set this if you're using PHP 5 on Linux. In this configuration
// if you don't, meetings in a different DST than you are currently
// in are offset by the DST offset incorrectly.
//
// Note that timezones can be set on a per-area basis, so strictly speaking this
// setting should be in areadefaults.inc.php, but as it is so important to set
// the right timezone it is included here.
//
// When upgrading an existing installation, this should be set to the
// timezone the web server runs in.  See the INSTALL document for more information.
//
// A list of valid timezones can be found at http://php.net/manual/timezones.php
// The following line must be uncommented by removing the '//' at the beginning

$timezone = "Europe/London";


/*******************
 * Database settings
 ******************/
// Which database system: "pgsql"=PostgreSQL, "mysql"=MySQL
$dbsys = "mysql";
// Hostname of database server. For pgsql, can use "" instead of localhost
// to use Unix Domain Sockets instead of TCP/IP. For mysql "localhost"
// tells the system to use Unix Domain Sockets, and $db_port will be ignored;
// if you want to force TCP connection you can use "127.0.0.1".
$db_host = "localhost";
// If you need to use a non standard port for the database connection you
// can uncomment the following line and specify the port number
// $db_port = 1234;
// Database name:
$db_database = "mrbs";
// Schema name.  This only applies to PostgreSQL and is only necessary if you have more
// than one schema in your database and also you are using the same MRBS table names in
// multiple schemas.
//$db_schema = "public";
// Database login user name:
$db_login = "mrbs";
// Database login password:
$db_password = 'mrbs-password';
// Prefix for table names.  This will allow multiple installations where only
// one database is available
$db_tbl_prefix = "mrbs_";
// Set $db_persist to TRUE to use PHP persistent (pooled) database connections.  Note
// that persistent connections are not recommended unless your system suffers significant
// performance problems without them.   They can cause problems with transactions and
// locks (see http://php.net/manual/en/features.persistent-connections.php) and although
// MRBS tries to avoid those problems, it is generally better not to use persistent
// connections if you can.
$db_persist = false;





/* Add lines from systemdefaults.inc.php and areadefaults.inc.php below here
   to change the default configuration. Do _NOT_ modify systemdefaults.inc.php
   or areadefaults.inc.php.  */


/******************
 * Display settings.  From areadefaults.inc.php CMG
 ******************/

// In the day view, to display times on the x-axis (along the top) and rooms on the y-axis (down
// the side set to true; the default/traditional version of MRBS has rooms along the top and
// times down the side.    Transposing the table can be useful if you have a large number of
// rooms and not many time slots.
// this was false CMG

// the below setting was ignored for the day calendar so I needed to edit the functions_table.inc file ,
// within the function  day_table_innterhtml , by making this assignment again just before the line if ($times_along_top)

$times_along_top = true;


/*************
 * Entry Types
 *************/

// Default type for new bookings
// (Note that the default type does not apply if the type field is mandatory)
//$default_type = "I";



// Entry types
//$vocab["type."]             = "Please select a type";
//$vocab["type.I"]            = "Internal";
//$vocab["type.E"]            = "External";
//$vocab["type.F"]            = "IXUX";
//$vocab["type.G"]            = "ArtT";

$booking_types = array('I', 'E', 'R','T', 'T', 'S');



/*********************************
 * Site identification information
 *********************************/

// Set to true to enable multisite operation, in which case the settings below are for the
// home site, identified by the empty string ''.   Other sites have their own supplementary
// config fies in the sites/<sitename> directory.
$multisite = false;
$default_site = '';

$mrbs_admin = "Your Administrator";
$mrbs_admin_email = "colm.mcgettrick@ul.ie";
// NOTE:  there are more email addresses in $mail_settings below.    You can also give
// email addresses in the format 'Full Name <address>', for example:
// $mrbs_admin_email = 'Booking System <admin_email@your.org>';
// if the name section has any "peculiar" characters in it, you will need
// to put the name in double quotes, e.g.:
// $mrbs_admin_email = '"Bloggs, Joe" <admin_email@your.org>';

// The company name is mandatory.   It is used in the header and also for email notifications.
// The company logo, additional information and URL are all optional.

$mrbs_company = "CSIS Dept";   // This line must always be uncommented ($mrbs_company is used in various places)

// Uncomment this next line to use a logo instead of text for your organisation in the header
//$mrbs_company_logo = "your_logo.gif";    // name of your logo file.   This example assumes it is in the MRBS directory

// Uncomment this next line for supplementary information after your company name or logo.
// This can contain HTML, for example if you want to include a link.
//$mrbs_company_more_info = "You can put additional information here";  // e.g. "XYZ Department"

// Uncomment this next line to have a link to your organisation in the header
//$mrbs_company_url = "http://www.your_organisation.com/";

// This is to fix URL problems when using a proxy in the environment.
// If links inside MRBS or in email notifications appear broken, then specify here the URL of
// your MRBS root directory, as seen by the users. For example:
// $url_base =  "http://example.com/mrbs";




/*******************
 * Themes
 *******************/

// Choose a theme for the MRBS.   The theme controls two aspects of the look and feel:
//   (a) the styling:  the most commonly changed colours, dimensions and fonts have been
//       extracted from the main CSS file and put into the styling.inc file in the appropriate
//       directory in the Themes directory.   If you want to change the colour scheme, you should
//       be able to do it by changing the values in the theme file.    More advanced styling changes
//       can be made by changing the rules in the CSS file.
//   (b) the header:  the header.inc file which contains the function used for producing the header.
//       This enables organisations to plug in their own header functions quite easily, in cases where
//       the desired corporate look and feel cannot be changed using the CSS alone and the mark-up
//       itself needs to be changed.
//
//  MRBS will look for the files "styling.inc" and "header.inc" in the directory Themes/$theme and
//  if it can't find them will use the files in Themes/default.    A theme directory can contain
//  a replacement styling.inc file or a replacement header.inc file or both.

// Available options are:

// "default"        Default MRBS theme
// "classic126"     Same colour scheme as MRBS 1.2.6

$theme = "default";

// Use the $custom_css_url to override the standard MRBS CSS.
//$custom_css_url = 'css/custom.css';

// Use the $custom_js_url to add your own JavaScript.
//$custom_js_url = 'js/custom.js';




/******************
 * Display settings
 ******************/

// [These are all variables that control the appearance of pages and could in time
//  become per-user settings]

// Start of week: 0 for Sunday, 1 for Monday, etc.
$weekstarts = 1;

// Days of the week that are weekdays
$weekdays = array(1, 2, 3, 4, 5);

// Set this to true to add styling to weekend days
$style_weekends = false;

// A two-dimensional array of holidays in yyyy-mm-dd format, indexed first by year, for example
// $holidays[2022] = array('2022-01-01', '2022-11-24');  // New Year's Day and US Thanksgiving 2022
// Dates can include ranges in the form 'yyyy-mm-dd..yyyy-mm-dd', eg
// $holidays[2022] = array('2022-01-01', '2022-07-01..2022-07-31');  // New Year's Day and all of July
// By default, bookings cannot be made on days that are designated holidays (see $prevent_booking_on_holidays).
// Holidays are styled differently in the main calendar views.
$holidays = array();

// Days of the week that should be hidden from display
// 0 for Sunday, 1 for Monday, etc.
// For example, if you want Saturdays and Sundays to be hidden set $hidden_days = array(0,6);
//
// By default the hidden days will be removed completely from the main table in the week and month
// views.   You can alternatively arrange for them to be shown as narrow, greyed-out columns
// by defining some custom CSS for the .hidden_day class.
$hidden_days = array();

// Whether or not to display the timezone
$display_timezone = false;

// Results per page for searching:
$search["count"] = 20;

// Page refresh time (in seconds). Set to 0 to disable.
// (Note that if MRBS detects that a client is on a metered network
// connection it will disable page refresh for that client.)
$refresh_rate = 0;

// Refresh rate (in seconds) for Ajax checking of valid bookings on the edit_entry page
// Set to 0 to disable.
$ajax_refresh_rate = 10;

// Refresh rate for page pre-fetches in the calendar views.   MRBS tries to improve
// performance of navigation between pages in the calendar view by pre-fetching some
// pages.   This setting determines how often (in seconds) the pre-fetches should be
// refreshed in order to keep them from getting out of date.  Set to 0 to disable.
$prefetch_refresh_rate = 30;

// Refresh rate (in seconds) when in kiosk mode
$kiosk_refresh_rate = 300; // 5 minutes

// Whether kiosk mode is enabled
$kiosk_mode_enabled = false;

// Default mode for kiosk mode.  Can be 'room' or 'area'.
$kiosk_default_mode = 'room';

// Whether to show a QR code in kiosk mode
// Note that PHP 7.4 or greater and the mbstring extension are required for a QR code
$kiosk_QR_code = true;

// Timeout if the exit kiosk mode dialog is not acted upon
$kiosk_exit_dialog_timeout = 10; // seconds

// Timeout if there is no activity on the kiosk exit page
$kiosk_exit_page_timeout = 10; // seconds

// Entries in monthly view can be shown as start/end slot, brief description or
// both. Set to "description" for brief description, "slot" for time slot and
// "both" for both. Default is "both", but 6 entries per day are shown instead
// of 12.
$monthly_view_entries_details = "both";

// To show week numbers in the main calendar, set this to true. The week
// numbers are only displayed if you set $weekstarts to start on the first
// day of the week in your locale and area's timezone.  (This assumes that
// the PHP IntlCalendar class is available; if not, the week is assumed to
// start on Mondays, ie the ISO stanard.)
$view_week_number = false;

// To display week numbers in the mini-calendars, set this to true. The week
// numbers are only displayed if you set $weekstarts to the start of the week.
// See the comment about when the week starts above.
$mincals_week_numbers = false;

// Whether or not the mini-calendars are displayed.  (Note that mini-calendars are only
// displayed anyway if the window is wide enough.)
$display_mincals = true;

// If the window is too narrow the mini-calendars are normally not displayed.  However by
// setting the following variable to true they will be displayed above the main calendar,
// provided the window is high enough.
$display_mincals_above = false;

// To display the endtime in the slot description, eg '09:00-09:30' instead of '09:00', set
// this to true.
$show_slot_endtime = false;

// To display the row labels (times, rooms or days) on the right hand side as well as the
// left hand side in the day and week views, set to true;
// (was called $times_right_side in earlier versions of MRBS)
// changed from false to true. CMG
$row_labels_both_sides = true;

// To display the column headers (times, rooms or days) on the bottom of the table as
// well as the top in the day and week views, set to true;
// was false CMG
$column_labels_both_ends = true;

// Show a line in the day and week views corresponding to the current time(
$show_timeline = true;  // normal mode
$show_timeline_kiosk = false;  // kiosk mode

// For bookings that allow registration, show the number of people that have
// registered and, if there is one, the registration limit.  This will typically
// be appended to the description in the calendar view, eg "Lecture [12/40]".
// The way the registration level is presented can be changed with a
// $vocab_override config setting.
$show_registration_level = true;

// Define default starting view (month, week or day)
// Default is day
$default_view = "day";

// The default setting for the week and month views: whether to view all the
// rooms (true) or not (false).
$default_view_all = true;

// If there's only one room in an area, the view_all option will not normally
// be offered.  This can be overridden by setting the variable below to true.
$always_offer_view_all = false;

// Define default room to start with (used by index.php)
// Room numbers can be determined by looking at the Edit or Delete URL for a
// room on the admin page.
// Default is 0
$default_room = 0;

// Define clipping behaviour for the cells in the day and week views.
// Set to true if you want the cells in the day and week views to be clipped.   This
// gives a table where all the rows have the same height, regardless of content.
// Alternatively set to false if you want the cells to expand to fit the content.
// (false not supported in IE6 and IE7 due to their incomplete CSS support)
$clipped = true;

// Define clipping behaviour for the cells in the month view.
// Set to true if you want all entries to have the same height. The
// short description may be clipped in this case. If set to false,
// each booking entry will be large enough to display all information.
$clipped_month = true;

// Set to true if you want the cells in the month view to scroll if there are too
// many bookings to display; set to false if you want the table cell to expand to
// accommodate the bookings.
$month_cell_scrolling = true;

// Define the maximum length of a string that can be displayed in an admin table cell
// (eg the rooms and users lists) before it is truncated.  (This is necessary because
// you don't want a cell to contain for example a 2 kbyte text string, which could happen
// with user defined fields).
$max_content_length = 20;  // characters

// The maximum length of a database field for which a text input can be used on a form
// (eg when editing a user or room).  If longer than this a text area will be used.
$text_input_max = 70;  // characters

// For inputs that have autocomplete options, eg the area and room match inputs on
// the report page, we can define how many characters need to be input before the
// options are displayed.  This enables us to prevent a huge long list of options
// being presented.   We define the breakpoints in an array.   For example if we set
// $autocomplete_length_breaks = array(25, 250, 2500); this means that if the number of options
// is less than 25 then they will be displayed when 0 characters are input, ie the input
// receives focus.   If the number of options is less than 250 then they will be displayed
// when 1 character is input and so on.    The array can be as long as you like.   If it
// is empty then the options are displayed when 0 characters are input.

// [Note: this variable is only applicable to older browsers that do not support the
// <datalist> element and instead fall back to a JavaScript emulation.   Browsers that
// support <datalist> present the options in a scrollable select box]
$autocomplete_length_breaks = array(25, 250, 2500);

// The default orientation for Excel output
// Options: 'portrait' or 'landscape'
$excel_default_orientation = 'portrait';

// The default paper size for Excel output
// Options: 'A3', 'A4', 'A5', 'LEGAL', 'LETTER' or 'TABLOID'
// You can instead, provided the size is supported in your version of Excel, use any of the integers defined in
// https://learn.microsoft.com/en-us/dotnet/api/documentformat.openxml.spreadsheet.pagesetup?view=openxml-2.8.1
// For example 43 for Japanese double postcard (200 mm by 148 mm)
$excel_default_paper = 'A4';

// The default orientation for PDF output
// Options: 'portrait' or 'landscape'
$pdf_default_orientation = 'portrait';

// The default paper size for PDF output
// Options: 'A3', 'A4', 'A5', 'LEGAL', 'LETTER' or 'TABLOID'
$pdf_default_paper = 'A4';

// Enable or disable state saving (eg pagination position, display length, filtering and sorting) for
// data tables, eg the users table or report output.
$state_save = true;

// The validity duration of the saved state for data tables.
// This option is also used to indicate to DataTables if localStorage or sessionStorage should be used
// for storing the table's state. When set to -1 sessionStorage will be used, while for 0 or greater
// localStorage will be used.  The difference between the two storage APIs is that sessionStorage retains
// data only for the current session (i.e. the current browser window).  Please note that the value is
// given in seconds. The value 0 is a special value as it indicates that the state can be stored and
// retrieved indefinitely with no time limit.
$state_duration = 0;

// Whether to sort users by their last names or not
$sort_users_by_last_name = false;

// When viewing all rooms in the week or month views, it can be very difficult to pick out an individual
// slot, which could be just one pixel wide.  Therefore, the user is taken to the day view first unless
// there's only one slot per day.  If $view_all_always_go_to_day_view is set to true, then we always go to
// the day view first, regardless of the number of slots.
$view_all_always_go_to_day_view = false;


